
// convert our ready to spawn buffer into an mps.
function CC_VMFtoMPS( pl, cmd, args )
	local buffer = "Structure\n{\n\tEntities\n\t{\n";
	local idx = 1;
	
	// have a ready to spawn buffer?
	if( pl.VMFSuite.ready_to_spawn ) then
		// convert!
		local ent;
		for _, ent in pairs( pl.VMFSuite.ready_to_spawn ) do
			idx = idx + 1;
			
			// write out entity header.
			local name = ent:keyvalues( "targetname" ) or idx;
			buffer = buffer .. "\t\t\"" .. name .. "\"\n\t\t{\n";
			
			// write out keyvalues.
			local k, v;
			for k, v in pairs( ent:keyvalues() ) do
				buffer = buffer .. "\t\t\t\"" .. k .. "\"\t\t\"" .. v .. "\"\n";
			end
			
			// write entity header close.
			buffer = buffer .. "\t\t}\n";
		end		
	
	end
	
	// close
	buffer = buffer .. "\t}\n}";
	
	file.Write( table.concat( args, " " ), buffer );
end
concommand.Add( "vmf_to_mps", CC_VMFtoMPS );
